
<?php $__env->startPush('head'); ?>
    <title>Medbot Purchase Order</title>
    <!--Fontawesome Link -->
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.15.4/css/all.css"
        integrity="sha384-DyZ88mC6Up2uqS4h/KRgHuoeGwBcD4Ng9SiP4dIRy0EXTlnuz47vAwmeGwVChigm" crossorigin="anonymous">
    <!--google Font -->
    <link href="https://fonts.googleapis.com/css?family=Lato:300,400,400i,700&display=swap" rel="stylesheet">
    
    <!-- style CSS -->
    <link rel="stylesheet" href="<?php echo e(url('assets/pdf/po/css/style.css')); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startPush('scripts'); ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-ka7Sk0Gln4gmtz2MlQnikT1wXgYsOg+OMhuP+IlRH9sENBO0LRn5q+8nbTov4+1p" crossorigin="anonymous">
    </script>
    <script>
        var invoiceValue = '<?php echo e(number_format(($purchaseOrder->price + $purchaseOrder->price * ($purchaseOrder->tax / 100)) * $purchaseOrder->quantity, 2)); ?>';

        function numberToWords(number) {
            var digit = ['zero', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine'];
            var elevenSeries = ['ten', 'eleven', 'twelve', 'thirteen', 'fourteen', 'fifteen', 'sixteen', 'seventeen',
                'eighteen', 'nineteen'
            ];
            var countingByTens = ['twenty', 'thirty', 'forty', 'fifty', 'sixty', 'seventy', 'eighty', 'ninety'];
            var shortScale = ['', 'thousand', 'million', 'billion', 'trillion'];

            number = number.toString();
            number = number.replace(/[\, ]/g, '');
            if (number != parseFloat(number)) return 'not a number';
            var x = number.indexOf('.');
            if (x == -1) x = number.length;
            if (x > 15) return 'too big';
            var n = number.split('');
            var str = '';
            var sk = 0;
            for (var i = 0; i < x; i++) {
                if ((x - i) % 3 == 2) {
                    if (n[i] == '1') {
                        str += elevenSeries[Number(n[i + 1])] + ' ';
                        i++;
                        sk = 1;
                    } else if (n[i] != 0) {
                        str += countingByTens[n[i] - 2] + ' ';
                        sk = 1;
                    }
                } else if (n[i] != 0) {
                    str += digit[n[i]] + ' ';
                    if ((x - i) % 3 == 0) str += 'hundred ';
                    sk = 1;
                }
                if ((x - i) % 3 == 1) {
                    if (sk) str += shortScale[(x - i - 1) / 3] + ' ';
                    sk = 0;
                }
            }
            if (x != number.length) {
                var y = number.length;
                str += 'and ';
                for (var i = x + 1; i < y; i++) str += digit[n[i]] + ' ';
            }
            str = str.replace(/\number+/g, ' ');
            str = str.trim() + "";
            return str.charAt(0).toUpperCase() + str.slice(1);

        }
        $(document).ready(function() {
            $('#invoice-value').append(numberToWords(invoiceValue));
        });
    </script>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>

<?php
    function convertToRoman($number) {
        $map = array('M' => 1000, 'CM' => 900, 'D' => 500, 'CD' => 400, 'C' => 100, 'XC' => 90, 'L' => 50, 'xl' => 40, 'x' => 10, 'ix' => 9, 'v' => 5, 'iv' => 4, 'i' => 1);
        $returnValue = '';
        while ($number > 0) {
            foreach ($map as $roman => $int) {
                if($number >= $int) {
                    $number -= $int;
                    $returnValue .= $roman;
                    break;
                }
            }
        }
        return $returnValue;
    }
?>

    <section class="main-section">
        <div class="container">
            <div class="logo-section">
                 
                <?php if($purchaseOrder->mainBuyer->pro_pic != ''): ?>
                    <img src="<?php echo e(url('user_files/' . $purchaseOrder->mainBuyer->pro_pic)); ?>" alt="logo">
                <?php endif; ?>
            </div>
            <div class="main-heading d-flex justify-content-between ">
                <div class="main-left">
                    <h6><?php echo e(ucfirst($purchaseOrder->mainBuyer->name)); ?> <?php echo e($purchaseOrder->mainBuyer->address); ?> <?php echo e(optional($purchaseOrder->mainBuyer->cityDetails)->name); ?> <?php echo e(optional($purchaseOrder->mainBuyer->stateDetails)->name); ?> - <?php echo e($purchaseOrder->mainBuyer->zipcode); ?></h6>
                    <span>(By Reg. Post/Courier/Fax)</span>
                </div>
                <div class="main-right">
                    <h6>Date: <?php echo date('d-m-Y', strtotime($purchaseOrder->date)); ?></h6>
                </div>
            </div>
            <h4 class="text-center py-3"><u>NOTIFICATION OF AWARD </u></h4>
            <div class="contact-details">
                <span>M/s. <?php echo e(ucfirst($purchaseOrder->createdUser->name)); ?></span>
                <ul>
                    <li>
                        <h6><?php echo e($purchaseOrder->createdUser->address); ?></h6>
                    </li>
                    <li>
                        <h6><?php echo e(optional($purchaseOrder->createdUser->cityDetails)->name); ?></h6>
                    </li>
                    <li>
                        <h6><?php echo e(optional($purchaseOrder->createdUser->stateDetails)->name); ?> - <?php echo e($purchaseOrder->createdUser->zipcode); ?></h6>
                    </li>
                    <li>
                        <h6>e-mail : <a
                                href="mailto:<?php echo e($purchaseOrder->createdUser->email); ?>"><?php echo e($purchaseOrder->createdUser->email); ?></a>
                        </h6>
                    </li>
                </ul>
            </div>
            <div class="sub py-3">
                <h6><span>Sub</span> : <span>Procurement of <?php echo e($purchaseOrder->product->product_name); ?> </span> </h6>
            </div>
            <div class="sub py-3">
                <h6 class="font-lite"><span>Ref</span> : <span>Tender Enquiry No. <?php echo e($purchaseOrder->tender_number); ?>

                        Dated <?php echo date('d-m-Y', strtotime($purchaseOrder->date)); ?> & Your
                        bid submitted for the same.</span> </h6>
            </div>
            <div class="letter">
                <h6>Dear Sir,</h6>
                <p>This is to inform you that your bid for the procurement of <span><b><u><?php echo e($purchaseOrder->product->product_name); ?> : <?php echo e($purchaseOrder->product->product_code); ?></u></b></span> against Tender Enquiry
                    <span><b><u>No. <?php echo e($purchaseOrder->tender_number); ?> Dated <?php echo date('d-m-Y', strtotime($purchaseOrder->date)); ?></u></b></span> has been accepted
                    and we are hereby placing
                    the order on behalf of MoH&FW for the following equipment to be supplied as per the Terms and
                    Conditions as
                    indicated below in continuation to the General Conditions of the Contract and Special Conditions of
                    Contract
                    and all the other sections as detailed and forming part of the Bid Document. The equipment should be
                    brand
                    new & unused and as per the Technical Specification as per our bid document along with the
                    amendments if
                    any and your offer along with technical clarification if any submitted by you which is attached as
                    <span><b><u>Annexure I.</u></b></span>
                    The bid document along with amendment if any forms an integral and inseparable part of this NOA
                </p>
            </div>
            <h6 class="py-3"><span>1. </span>Prices</h6>
            <div class="table-responsive">
                <table border="1">
                    <thead>
                        <th>Sl.No</th>
                        <th>Brief Description of item/goods </th>
                        <th>Qty.</th>
                        <th>Unit Price(Rs.)</th>
                        <th>Total Price(Rs.)</th>
                    </thead>
                    <tbody>
                        <tr>
                            <td>A</td>
                            <td colspan="4">
                                <span><?php echo e($purchaseOrder->product->product_name); ?></span>
                                <span>Model : <?php echo e($purchaseOrder->product->product_code); ?></span>
                            </td>
                        </tr>
                        <?php $count = 1;  ?>
                        <tr>
                            <td><?php echo convertToRoman($count) . '. '; $count++; ?></td>
                            <td>Price at Consignee Site (excluding GST)</td>
                            <td rowspan="3"><?php echo e($purchaseOrder->quantity); ?> Nos</td>
                            <td><?php echo e(number_format($purchaseOrder->price, 2)); ?></td>
                            <td><?php echo e(number_format($purchaseOrder->price * $purchaseOrder->quantity, 2)); ?></td>
                        </tr>
                        <tr>
                            <td><?php echo convertToRoman($count) . '. '; $count++; ?></td>
                            <td>Goods & Service Tax (@ <?php echo e($purchaseOrder->tax); ?>%) </td>
                            <td><?php echo e(number_format($purchaseOrder->price * ($purchaseOrder->tax / 100), 2)); ?></td>
                            <td><?php echo e(number_format($purchaseOrder->price * $purchaseOrder->quantity * ($purchaseOrder->tax / 100), 2)); ?></td>
                        </tr>
                        <tr>
                            <td><?php echo convertToRoman($count) . '. '; $count++; ?></td>
                            <td>Total Price at consignee site inclusive of taxes</td>
                            <td><?php echo e(number_format($purchaseOrder->price + $purchaseOrder->price * ($purchaseOrder->tax / 100), 2)); ?></td>
                            <td><?php echo e(number_format(($purchaseOrder->price + $purchaseOrder->price * ($purchaseOrder->tax / 100)) * $purchaseOrder->quantity, 2)); ?>

                            </td>
                        </tr>
                        <tr>
                            <td colspan="5">Total Value (in words): <b id='invoice-value'></b></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <p class="py-3">Purchaser reserves the right to place the balance tendered quantity including tolerance at
                the same
                price and terms and conditions till the validity of this contract.</p>
            <h6 class="py-3"><span>2. </span>Terms &amp; Conditions</h6>
            <p class="py-3">The prices accepted are firm and fixed during the currency of the contract. The scope of
                supply shall be as
                per terms & conditions given below and as detailed in the bid document: -</p>
            <div class="table-responsive">
                <?php $count = 1;  ?>
                <table border="1">
                    <thead>
                        <th>Sl.No</th>
                        <th>Item </th>
                        <th>Description</th>
                    </thead>
                    <tbody>
                        <tr>
                            <td><?php echo convertToRoman($count) . ') '; $count++; ?></td>
                            <td>Name & Address of the Purchaser</td>
                            <td>
                                <ul>
                                    <li>
                                        <?php echo e(ucfirst($purchaseOrder->purchaser->name)); ?>

                                    </li>
                                    <li>
                                        <?php echo e($purchaseOrder->purchaser->address); ?>

                                    </li>
                                    <li>
                                        <?php echo e(optional($purchaseOrder->purchaser->cityDetails)->name); ?>

                                    </li>
                                    <li>
                                        <?php echo e(optional($purchaseOrder->purchaser->stateDetails)->name); ?> - <?php echo e($purchaseOrder->purchaser->zipcode); ?>

                                    </li>
                                </ul>
                            </td>
                        </tr>
                        <?php if($purchaseOrder->mainBuyer->user_type == '6'): ?>
                            <tr>
                                <td><?php echo convertToRoman($count) . ') '; $count++; ?></td>
                                <td>Name & Address of the Consignee(s)</td>
                                <td><b><?php echo e(ucfirst($purchaseOrder->mainBuyer->name)); ?>, <?php echo e(optional($purchaseOrder->mainBuyer->cityDetails)->name); ?></b>
                                </td>
                            </tr>
                        <?php endif; ?>
                        <tr>
                            <td><?php echo convertToRoman($count) . ') '; $count++; ?></td>
                            <td>Name & Address of Manufacturer</td>
                            <td>
                                <ul>
                                    <li>
                                        <?php echo e(ucfirst($purchaseOrder->manufacturer->name)); ?>

                                    </li>
                                    <li>
                                        <?php echo e($purchaseOrder->manufacturer->address); ?>

                                    </li>
                                    <li>
                                        <?php echo e(optional($purchaseOrder->manufacturer->cityDetails)->name); ?>

                                    </li>
                                    <li>
                                        <?php echo e(optional($purchaseOrder->manufacturer->stateDetails)->name); ?> - <?php echo e($purchaseOrder->manufacturer->zipcode); ?>

                                    </li>
                                </ul>
                            </td>
                        </tr>
                        <tr>
                            <td><?php echo convertToRoman($count) . ') '; $count++; ?></td>
                            <td>Country of Origin </td>
                            <td>India</td>
                        </tr>
                        <tr>
                            <td><?php echo convertToRoman($count) . ') '; $count++; ?></td>
                            <td>Delivery Period </td>
                            <td>
                                <p class="mb-3">
                                    <?php echo $purchaseOrder->delivery_period; ?>

                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td><?php echo convertToRoman($count) . ') '; $count++; ?></td>
                            <td>Terms of Delivery </td>
                            <td><?php echo $purchaseOrder->terms_service; ?></td>
                        </tr>
                        <tr>
                            <td><?php echo convertToRoman($count) . ') '; $count++; ?></td>
                            <td>Despatch Instructions </td>
                            <td>
                                <p><?php echo $purchaseOrder->dispatch_instruction; ?></p>
                            </td>
                        </tr>
                        <tr>
                            <td><?php echo convertToRoman($count) . ') '; $count++; ?></td>
                            <td>Packing & Marking </td>
                            <td>
                                <p class="mb-2">
                                    <?php echo $purchaseOrder->packing_making; ?>

                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td><?php echo convertToRoman($count) . ') '; $count++; ?></td>
                            <td>Inspecting Officer </td>
                            <td><?php echo $purchaseOrder->inspecting_officer; ?></td>
                        </tr>
                        <tr>
                            <td><?php echo convertToRoman($count) . ') '; $count++; ?></td>
                            <td>Inspection Authority </td>
                            <td><?php echo $purchaseOrder->inspection_authority; ?></td>
                        </tr>
                        <tr>
                            <td><?php echo convertToRoman($count) . ') '; $count++; ?></td>
                            <td>Pre despatch Inspection of goods Located in India </td>
                            <td>
                                <p>
                                    <?php echo $purchaseOrder->predespatch_goods; ?>

                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td><?php echo convertToRoman($count) . ') '; $count++; ?></td>
                            <td>Performance Security </td>
                            <td>
                                <p>
                                    <?php echo $purchaseOrder->performance_security; ?>

                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td><?php echo convertToRoman($count) . ') '; $count++; ?></td>
                            <td>Warranty Terms </td>
                            <td>
                                <p>
                                    <?php echo $purchaseOrder->warranty_terms; ?>

                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td><?php echo convertToRoman($count) . ') '; $count++; ?></td>
                            <td>Comprehensive Annual Maintenance Contract </td>
                            <td>
                                <p>
                                    <?php echo $purchaseOrder->annual_maintanace; ?>

                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td><?php echo convertToRoman($count) . ') '; $count++; ?></td>
                            <td>Liquidated damages </td>
                            <td>
                                <p>
                                    <?php echo $purchaseOrder->liquidated_damage; ?>

                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td><?php echo convertToRoman($count) . ') '; $count++; ?></td>
                            <td>Paying Authority </td>
                            <td>
                                <p>
                                    <?php echo $purchaseOrder->paying_authority; ?>

                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td><?php echo convertToRoman($count) . ') '; $count++; ?></td>
                            <td>Payment Terms </td>
                            <td>
                                <p>
                                    <?php echo $purchaseOrder->payment_terms; ?>

                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td><?php echo convertToRoman($count) . ') '; $count++; ?></td>
                            <td>Resolution of disputes</td>
                            <td>
                                <?php echo $purchaseOrder->resolution_disputes; ?>

                            </td>
                        </tr>
                        <tr>
                            <td><?php echo convertToRoman($count) . ') '; $count++; ?></td>
                            <td>Other Instructions </td>
                            <td>
                                <?php echo $purchaseOrder->other_instruction; ?>

                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <p class="py-3">Please acknowledge receipt of this NOA by sending a copy of the same duly signed as a
                token of acceptance to
                the undersigned, immediately on receipt of which contract agreement (as given in the tender document)
                will be
                signed between the purchaser and the supplier.
            </p>
            <h6 class="py-3">Thanking You</h6>
            <h6 class="py-3">For <?php echo e(ucfirst($purchaseOrder->mainBuyer->name)); ?>.</h6>
            <img style="width: 140px;" src="<?php echo e(url('assets/pdf/po/img/sign.png')); ?>" alt="sign">
            <h6 class="py-3">HEAD (PCD)</h6>
            <h6 class="py-3">Encl: </h6>
            <ul>
                <li>
                    <h6>Technical Specifications Detailed in Annexure-I .....................Pages</h6>
                </li>
                <li>
                    <h6>Integrity Pact attached at Annexure-II</h6>
                </li>
            </ul>
            <h6 class="py-3">Copy to: </h6>
            <ul class="py-3">
                <li>
                    <h6>I) For Records:- </h6>
                    <ul class="left">
                        <li>
                            <h6>CFO, <?php echo e(ucfirst($purchaseOrder->mainBuyer->name)); ?>., <?php echo e(optional($purchaseOrder->mainBuyer->cityDetails)->name); ?> </h6>
                        <li>
                            <h6>DGM (CMC), <?php echo e(ucfirst($purchaseOrder->mainBuyer->name)); ?>., <?php echo e(optional($purchaseOrder->mainBuyer->cityDetails)->name); ?> </h6>
                        <li>
                            <h6>Office Copy </h6>
                        </li>
                    </ul>
                </li>
                <li>
                    <h6>II) For Information and Needful action </h6>
                    <ul class="left">
                        <li>
                            <h6>The Director, All India Institute of Medical Sciences, AlIMS Temporary Campus, First
                                Floor,
                                Government Siddhartha Medical College, NH 16 service road, Gunadala, Vijayawada (AP) -
                                520008 Email: director@aiimsmangalagiri.edu.in </h6>
                        </li>
                    </ul>
                </li>
            </ul>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('pdf-templates.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/meddbot/public_html/resources/views/pdf-templates/po.blade.php ENDPATH**/ ?>