<?php
    function convertToRoman($number)
    {
        $map = ['M' => 1000, 'CM' => 900, 'D' => 500, 'CD' => 400, 'C' => 100, 'XC' => 90, 'L' => 50, 'xl' => 40, 'x' => 10, 'ix' => 9, 'v' => 5, 'iv' => 4, 'i' => 1];
        $returnValue = '';
        while ($number > 0) {
            foreach ($map as $roman => $int) {
                if ($number >= $int) {
                    $number -= $int;
                    $returnValue .= $roman;
                    break;
                }
            }
        }
        return $returnValue;
    }
    function convertToWords(float $amount) {
        $amount_after_decimal = round($amount - ($num = floor($amount)), 2) * 100;
        // Check if there is any number after decimal
        $amt_hundred = null;
        $count_length = strlen($num);
        $x = 0;
        $string = [];
        $change_words = [0 => 'Zero', 1 => 'One', 2 => 'Two', 3 => 'Three', 4 => 'Four', 5 => 'Five', 6 => 'Six', 7 => 'Seven', 8 => 'Eight', 9 => 'Nine', 10 => 'Ten', 11 => 'Eleven', 12 => 'Twelve', 13 => 'Thirteen', 14 => 'Fourteen', 15 => 'Fifteen', 16 => 'Sixteen', 17 => 'Seventeen', 18 => 'Eighteen', 19 => 'Nineteen', 20 => 'Twenty', 30 => 'Thirty', 40 => 'Forty', 50 => 'Fifty', 60 => 'Sixty', 70 => 'Seventy', 80 => 'Eighty', 90 => 'Ninety'];
        $here_digits = ['', 'Hundred', 'Thousand', 'Lakh', 'Crore'];
        while ($x < $count_length) {
            $get_divider = $x == 2 ? 10 : 100;
            $amount = floor($num % $get_divider);
            $num = floor($num / $get_divider);
            $x += $get_divider == 10 ? 1 : 2;
            if ($amount) {
                $add_plural = ($counter = count($string)) && $amount > 9 ? 's' : null;
                $amt_hundred = $counter == 1 && $string[0] ? ' and ' : null;
                $string[] =
                    $amount < 21
                        ? $change_words[$amount] .
                            ' ' .
                            $here_digits[$counter] .
                            $add_plural .
                            ' 
         ' .
                            $amt_hundred
                        : $change_words[floor($amount / 10) * 10] .
                            ' ' .
                            $change_words[$amount % 10] .
                            ' 
         ' .
                            $here_digits[$counter] .
                            $add_plural .
                            ' ' .
                            $amt_hundred;
            } else {
                $string[] = null;
            }
        }
        $implode_to_Rupees = implode('', array_reverse($string));
        $get_paise =
            $amount_after_decimal > 0
                ? 'And ' .
                    ($change_words[$amount_after_decimal / 10] .
                        " 
   " .
                        $change_words[$amount_after_decimal % 10]) .
                    ' Paise'
                : '';
        return ($implode_to_Rupees ? $implode_to_Rupees . 'Rupees ' : '') . $get_paise;
    }

?>
<style>
    .logo-section {
        /*    padding: 40px 0px;*/
    }

    .logo-section img {
        width: 150px;
    }

    .main-heading {
        width: 100%;
    }

    .contact-details h6 {
        font-size: 9px;
        margin: 0;
        padding: 0;
    }

    .sub {
        margin-bottom: 0px;
        padding-bottom: 0px;
    }

    div {
        box-sizing: border-box;
    }

    td,
    th {
        padding: 15px !important;
    }

    table {
        padding: 5px;
    }
   

</style>
<section class="main-section">
    <div class="container">
        <div class="logo-section">
            <?php if($purchaseOrder->mainBuyer->pro_pic != ''): ?>
                <img src="<?php echo e(url('user_files/' . $purchaseOrder->mainBuyer->pro_pic)); ?>" alt="logo">
            <?php endif; ?>
        </div>
        <table>
            <tr>
                <td style="">
                    <div class="main-left">
                        <h6 style="font-size: 10px;" class="head-text"><?php echo e(ucfirst($purchaseOrder->mainBuyer->name)); ?>

                            <?php echo e($purchaseOrder->mainBuyer->address); ?>

                            <?php echo e(optional($purchaseOrder->mainBuyer->cityDetails)->name); ?>

                            <?php echo e(optional($purchaseOrder->mainBuyer->stateDetails)->name); ?> -
                            <?php echo e($purchaseOrder->mainBuyer->zipcode); ?></h6>
                        <span>(By Reg. Post/Courier/Fax)</span>
                    </div>
                </td>
                <td>
                    <div class="main-right">
                        <h6 style="text-align: right; font-size: 10px;" class="head-text">Date: <?php echo date('d-m-Y', strtotime($purchaseOrder->created_at)); ?></h6>
                    </div>
                </td>
            </tr>
        </table>
        <!--
            <div class="main-heading d-flex justify-content-between ">
                <div class="main-left">
                    <h6>Dwellysmith A squrare, Vadodara. Kerala Victoria - 201010</h6>
                    <span>(By Reg. Post/Courier/Fax)</span>
                </div>
                <div class="main-right">
                    <h6>Date: 05-08-2022</h6>
                </div>
            </div>
-->
        <h4 style="text-align: center!important; font-size: 15px;" class="text-center  heading"><u>NOTIFICATION OF AWARD
            </u></h4>
        <div class="contact-details">
            <h6>M/s. <?php echo e(ucfirst($purchaseOrder->createdUser->name)); ?></h6>
            <h6><?php echo e($purchaseOrder->createdUser->address); ?></h6>
            <h6><?php echo e(optional($purchaseOrder->createdUser->cityDetails)->name); ?></h6>
            <h6><?php echo e(optional($purchaseOrder->createdUser->stateDetails)->name); ?> -
                <?php echo e($purchaseOrder->createdUser->zipcode); ?></h6>
            <h6>e-mail : <a
                    href="mailto:<?php echo e($purchaseOrder->createdUser->email); ?>"><?php echo e($purchaseOrder->createdUser->email); ?></a>
            </h6>
            <h6>Sub : Procurement of Purchase Order</h6>
        </div>
        <h6 style="font-size: 9px; "><span>Sub</span> : <span>Procurement of
                Purchase Order </span> </h6>
        <h6 style="font-size: 9px; " class="font-lite"><span>Ref</span> : <span>Tender Enquiry No.
                <?php echo e($purchaseOrder->tender_number); ?>

                Dated <?php echo date('d-m-Y', strtotime($purchaseOrder->date)); ?> &amp; Your
                bid submitted for the same.</span> </h6>
        <div class="letter">
            <h6 style="font-size: 9px; ">Dear Sir,</h6>
            <p>This is to inform you that your bid for the procurement of Purchase Order
                <span><b><u> :
                            </u></b></span> against Tender Enquiry
                <span><b><u>No. 123123 Dated 05-08-2022</u></b></span> has been accepted
                and we are hereby placing
                the order on behalf of MoH&amp;FW for the following equipment to be supplied as per the Terms and
                Conditions as
                indicated below in continuation to the General Conditions of the Contract and Special Conditions of
                Contract
                and all the other sections as detailed and forming part of the Bid Document. The equipment should be
                brand
                new &amp; unused and as per the Technical Specification as per our bid document along with the
                amendments if
                any and your offer along with technical clarification if any submitted by you which is attached as
                <span><b><u>Annexure I.</u></b></span>
                The bid document along with amendment if any forms an integral and inseparable part of this NOA
            </p>
        </div>
        <h6 style="font-size: 9px; " class="py-3"><span> </span>Product Details</h6>
        <div class="table-responsive">
            <table class="table2" border="1">
                <tr>
                    <th>Sl.No</th>
                    <th>Brief Description of item/goods </th>
                    <th>Qty.</th>
                    <th>Sl No.</th>
                    <th>Price Desc.</th>
                    <th>Unit Price(Rs.)</th>
                    <th>Total Price(Rs.)</th>
                </tr>
                <?php $slNo = 1; $sum = 0; ?>
                <?php $__currentLoopData = $purchaseOrder->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php $count = 1; ?>
                    <tr>
                        <td rowspan="3"><?php echo e($slNo); ?>.<?php $slNo++; ?></td>
                        <td rowspan="3">
                            <span><?php echo e(ucfirst($item->productDetails->product_name)); ?></span>
                            <span>Model : <?php echo e($item->productDetails->product_code); ?></span>
                        </td>
                        <td rowspan="3"><?php echo e($item->quantity); ?> Nos</td>
                        <td><?php echo convertToRoman($count) . '. '; $count++; ?></td>
                        <td>Price at Consignee Site (excluding GST)</td>
                        <td><?php echo e(number_format($item->price, 2)); ?></td>
                        <td><?php echo e(number_format($item->price * $item->quantity, 2)); ?></td>
                    </tr>
                    <tr>
                        <?php $taxAmt = $item->price * ($item->tax / 100); ?>
                        <td><?php echo convertToRoman($count) . '. '; $count++; ?></td>
                        <td>Goods & Service Tax (@ <?php echo e($item->tax); ?> %) </td>
                        <td><?php echo e(number_format($taxAmt, 2)); ?></td>
                        
                        <td><?php echo e(number_format($taxAmt * $item->quantity, 2)); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo convertToRoman($count) . '. '; $count++; ?></td>
                        <td>Total Price at consignee site inclusive of taxes</td>
                        <td><?php echo e(number_format($item->price + $item->price * ($item->tax / 100), 2)); ?></td>
                        <?php
                            $totalPrice = ($item->price + $item->price * ($item->tax / 100)) * $item->quantity;
                            $sum = $sum + $totalPrice;
                        ?>
                        <td><?php echo e(number_format($totalPrice, 2)); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <tr>
                    <td>
                        Total Value:
                        <br>
                    </td>
                    <td colspan="6" > <span style="font-size: 18px;     margin-bottom: 10px;" ><b><span style="font-size: 20px;" >Rs :</span> <?php echo e(number_format($sum, 2)); ?> /-</b></span>
                        <br>
                        
                        
                    </td>
                </tr>
            </table>
        </div>
        <p class="py-3">Purchaser reserves the right to place the balance tendered quantity including tolerance at
            the same
            price and terms and conditions till the validity of this contract.</p>
        <h6 style="font-size: 9px; " class="py-3"><span>2. </span>Terms &amp; Conditions</h6>
        <p class="py-3">The prices accepted are firm and fixed during the currency of the contract. The scope of
            supply shall be as
            per terms &amp; conditions given below and as detailed in the bid document: -</p>
        <div class="table-responsive">
            <?php $count = 1;  ?>
            <table border="1">
                <!--                <thead>-->
                <tr>
                    <th>Sl.No</th>
                    <th>Item </th>
                    <th>Description</th>
                </tr>
                <!--                </thead>-->
                <tbody>
                    <tr>
                        <td><?php
                            echo convertToRoman($count) . ') ';
                            $count++;
                        ?></td>
                        <td>Name & Address of the Purchaser</td>
                        <td>
                            <ul>
                                <li>
                                    <?php echo e(ucfirst($purchaseOrder->purchaser->name)); ?>

                                </li>
                                <li>
                                    <?php echo e($purchaseOrder->purchaser->address); ?>

                                </li>
                                <li>
                                    <?php echo e(optional($purchaseOrder->purchaser->cityDetails)->name); ?>

                                </li>
                                <li>
                                    <?php echo e(optional($purchaseOrder->purchaser->stateDetails)->name); ?> -
                                    <?php echo e($purchaseOrder->purchaser->zipcode); ?>

                                </li>
                            </ul>
                        </td>
                    </tr>
                    <?php if($purchaseOrder->mainBuyer->user_type == '6'): ?>
                        <tr>
                            <td><?php
                                echo convertToRoman($count) . ') ';
                                $count++;
                            ?></td>
                            <td>Name &amp; Address of the Consignee(s)</td>
                            <td><b><?php echo e(ucfirst($purchaseOrder->mainBuyer->name)); ?>,
                                    <?php echo e(optional($purchaseOrder->mainBuyer->cityDetails)->name); ?></b>
                            </td>
                        </tr>
                    <?php endif; ?>
                    <tr>
                        <td><?php
                            echo convertToRoman($count) . ') ';
                            $count++;
                        ?></td>
                        <td>Name & Address of Manufacturer</td>
                        <td  >
                            <table border="1" >
                                <?php $__currentLoopData = $po_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                
                                        
                                        
                                            <tr>
                                                <th><b> <?php echo e(ucfirst($val->product_name)); ?></b></th>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <ul >
                                            
                                            <li>
                                                <?php echo e(ucfirst($val->name)); ?>

                                            </li>
                                            <li>
                                                <?php echo e($val->address); ?>

                                            </li>
                                            <li>
                                                <?php echo e($val->countryname); ?>

                                            </li>
                                            <li>
                                                <?php echo e($val->statename); ?> -
                                                <?php echo e($val->zipcode); ?>

                                            </li>
                                        </ul>
                                                </td>
                                            </tr>
                                       
                                        
                                     
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </table>
                           
                           
                        </td>



                    </tr>
                    <tr>
                        <td><?php
                            echo convertToRoman($count) . ') ';
                            $count++;
                        ?></td>
                        <td>Country of Origin </td>
                        <td>India</td>
                    </tr>
                    <tr>
                        <td><?php
                            echo convertToRoman($count) . ') ';
                            $count++;
                        ?></td>
                        <td>Delivery Period </td>
                        <td>
                            <p class="mb-3">
                                <?php echo $purchaseOrder->delivery_period; ?>

                            </p>
                        </td>
                    </tr>
                    <tr>
                        <td><?php
                            echo convertToRoman($count) . ') ';
                            $count++;
                        ?></td>
                        <td>Terms of Delivery </td>
                        <td><?php echo $purchaseOrder->terms_service; ?></td>
                    </tr>
                    <tr>
                        <td><?php
                            echo convertToRoman($count) . ') ';
                            $count++;
                        ?></td>
                        <td>Despatch Instructions </td>
                        <td>
                            <p><?php echo $purchaseOrder->dispatch_instruction; ?></p>
                        </td>
                    </tr>
                    <tr>
                        <td><?php
                            echo convertToRoman($count) . ') ';
                            $count++;
                        ?></td>
                        <td>Packing & Marking </td>
                        <td>
                            <p class="mb-2">
                                <?php echo $purchaseOrder->packing_making; ?>

                            </p>
                        </td>
                    </tr>
                    <tr>
                        <td><?php
                            echo convertToRoman($count) . ') ';
                            $count++;
                        ?></td>
                        <td>Inspecting Officer </td>
                        <td><?php echo $purchaseOrder->inspecting_officer; ?></td>
                    </tr>
                    <tr>
                        <td><?php
                            echo convertToRoman($count) . ') ';
                            $count++;
                        ?></td>
                        <td>Inspection Authority </td>
                        <td><?php echo $purchaseOrder->inspection_authority; ?></td>
                    </tr>
                    <tr>
                        <td><?php
                            echo convertToRoman($count) . ') ';
                            $count++;
                        ?></td>
                        <td>Pre despatch Inspection of goods Located in India </td>
                        <td>
                            <p>
                                <?php echo $purchaseOrder->predespatch_goods; ?>

                            </p>
                        </td>
                    </tr>
                    <tr>
                        <td><?php
                            echo convertToRoman($count) . ') ';
                            $count++;
                        ?></td>
                        <td>Performance Security </td>
                        <td>
                            <p>
                                <?php echo $purchaseOrder->performance_security; ?>

                            </p>
                        </td>
                    </tr>
                    <tr>
                        <td><?php
                            echo convertToRoman($count) . ') ';
                            $count++;
                        ?></td>
                        <td>Warranty Terms </td>
                        <td>
                            <p>
                                <?php echo $purchaseOrder->warranty_terms; ?>

                            </p>
                        </td>
                    </tr>
                    <tr>
                        <td><?php
                            echo convertToRoman($count) . ') ';
                            $count++;
                        ?></td>
                        <td>Comprehensive Annual Maintenance Contract </td>
                        <td>
                            <p>
                                <?php echo $purchaseOrder->annual_maintanace; ?>

                            </p>
                        </td>
                    </tr>
                    <tr>
                        <td><?php
                            echo convertToRoman($count) . ') ';
                            $count++;
                        ?></td>
                        <td>Liquidated damages </td>
                        <td>
                            <p>
                                <?php echo $purchaseOrder->liquidated_damage; ?>

                            </p>
                        </td>
                    </tr>
                    <tr>
                        <td><?php
                            echo convertToRoman($count) . ') ';
                            $count++;
                        ?></td>
                        <td>Paying Authority </td>
                        <td>
                            <p>
                                <?php echo $purchaseOrder->paying_authority; ?>

                            </p>
                        </td>
                    </tr>
                    <tr>
                        <td><?php
                            echo convertToRoman($count) . ') ';
                            $count++;
                        ?></td>
                        <td>Payment Terms </td>
                        <td>
                            <p>
                                <?php echo $purchaseOrder->payment_terms; ?>

                            </p>
                        </td>
                    </tr>
                    <tr>
                        <td><?php
                            echo convertToRoman($count) . ') ';
                            $count++;
                        ?></td>
                        <td>Resolution of disputes</td>
                        <td>
                            <?php echo $purchaseOrder->resolution_disputes; ?>

                        </td>
                    </tr>
                    <tr>
                        <td><?php
                            echo convertToRoman($count) . ') ';
                            $count++;
                        ?></td>
                        <td>Other Instructions </td>
                        <td>
                            <?php echo $purchaseOrder->other_instruction; ?>

                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
        <p class="py-3">Please acknowledge receipt of this NOA by sending a copy of the same duly signed as a
            token of acceptance to
            the undersigned, immediately on receipt of which contract agreement (as given in the tender document)
            will be
            signed between the purchaser and the supplier.
        </p>
        <h6 style="font-size: 9px;" class="py-3">Thanking You</h6>
        <h6 style="font-size: 9px; " class="py-3">For <?php echo e(ucfirst($purchaseOrder->mainBuyer->name)); ?>.</h6>
        <img style="width: 140px;" src="<?php echo e(url('/assets/signatures/' . Auth::user()->signature)); ?>" alt="sign">
        <h6 style="font-size: 9px; " class="py-3">HEAD (PCD)</h6>
        <h6 style="font-size: 9px; " class="py-3">Encl: </h6>
        <ul style="font-size: 9px; list-style: upper-roman;">
            <li style="font-size: 9px;  margin: 0px;  padding: 0px;">
                <h6 style="font-size: 9px; ">Technical Specifications Detailed in Annexure-I .....................Pages
                </h6>
            </li>
            <li>
                <h6 style="font-size: 9px; margin: 0px;  padding: 0px;">Integrity Pact attached at Annexure-II</h6>
            </li>
        </ul>
        <h6 style="font-size: 9px;" class="py-3">Copy to: </h6>
        <ul class="py-3" style="font-size: 9px; list-style-type: upper-roman;">
            <li>
                <h6 style="font-size: 9px; ">I) For Records:- </h6>
                <ul class="left" style="font-size: 9px; list-style-type: upper-roman;">
                    <li>
                        <h6 style="font-size: 9px; ">CFO, <?php echo e(ucfirst($purchaseOrder->mainBuyer->name)); ?>.,
                            <?php echo e(optional($purchaseOrder->mainBuyer->cityDetails)->name); ?> </h6>
                    </li>
                    <li>
                        <h6 style="font-size: 9px; ">DGM (CMC), <?php echo e(ucfirst($purchaseOrder->mainBuyer->name)); ?>.,
                            <?php echo e(optional($purchaseOrder->mainBuyer->cityDetails)->name); ?> </h6>
                    </li>
                    <li>
                        <h6 style="font-size: 9px; ">Office Copy </h6>
                    </li>
                </ul>
            </li>
            <li>
                <h6 style="font-size: 9px; ">II) For Information and Needful action </h6>
                <ul class="left" style="font-size: 9px; list-style-type: upper-roman;">
                    <li>
                        <h6 style="font-size: 9px; ">The Director, All India Institute of Medical Sciences, AlIMS
                            Temporary Campus, First
                            Floor,
                            Government Siddhartha Medical College, NH 16 service road, Gunadala, Vijayawada (AP) -
                            520008 Email: director@aiimsmangalagiri.edu.in </h6>
                    </li>
                </ul>
            </li>
        </ul>
    </div>
</section>
<?php /**PATH /home/meddbot/public_html/resources/views/pdf-templates/po-pdf.blade.php ENDPATH**/ ?>