<?php
/**
 * Block Styles
 *
 * @link https://developer.wordpress.org/reference/functions/register_block_style/
 *
 * @package WordPress
 * @subpackage Meddbot
 * @since Meddbot 1.0
 */

if ( function_exists( 'register_block_style' ) ) {
	/**
	 * Register block styles.
	 *
	 * @since Meddbot 1.0
	 *
	 * @return void
	 */
	function Meddbot_register_block_styles() {
		// Columns: Overlap.
		register_block_style(
			'core/columns',
			array(
				'name'  => 'meddbot-columns-overlap',
				'label' => esc_html__( 'Overlap', 'meddbot' ),
			)
		);

		// Cover: Borders.
		register_block_style(
			'core/cover',
			array(
				'name'  => 'meddbot-border',
				'label' => esc_html__( 'Borders', 'meddbot' ),
			)
		);

		// Group: Borders.
		register_block_style(
			'core/group',
			array(
				'name'  => 'meddbot-border',
				'label' => esc_html__( 'Borders', 'meddbot' ),
			)
		);

		// Image: Borders.
		register_block_style(
			'core/image',
			array(
				'name'  => 'meddbot-border',
				'label' => esc_html__( 'Borders', 'meddbot' ),
			)
		);

		// Image: Frame.
		register_block_style(
			'core/image',
			array(
				'name'  => 'meddbot-image-frame',
				'label' => esc_html__( 'Frame', 'meddbot' ),
			)
		);

		// Latest Posts: Dividers.
		register_block_style(
			'core/latest-posts',
			array(
				'name'  => 'meddbot-latest-posts-dividers',
				'label' => esc_html__( 'Dividers', 'meddbot' ),
			)
		);

		// Latest Posts: Borders.
		register_block_style(
			'core/latest-posts',
			array(
				'name'  => 'meddbot-latest-posts-borders',
				'label' => esc_html__( 'Borders', 'meddbot' ),
			)
		);

		// Media & Text: Borders.
		register_block_style(
			'core/media-text',
			array(
				'name'  => 'meddbot-border',
				'label' => esc_html__( 'Borders', 'meddbot' ),
			)
		);

		// Separator: Thick.
		register_block_style(
			'core/separator',
			array(
				'name'  => 'meddbot-separator-thick',
				'label' => esc_html__( 'Thick', 'meddbot' ),
			)
		);

		// Social icons: Dark gray color.
		register_block_style(
			'core/social-links',
			array(
				'name'  => 'meddbot-social-icons-color',
				'label' => esc_html__( 'Dark gray', 'meddbot' ),
			)
		);
	}
	add_action( 'init', 'Meddbot_register_block_styles' );
}
