<?php

/**
 * Functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package WordPress
 * @subpackage Meddbot
 * @since Meddbot 1.0
 */

// This theme requires WordPress 5.3 or later.
if (version_compare($GLOBALS['wp_version'], '5.3', '<')) {
	require get_template_directory() . '/inc/back-compat.php';
}

if (! function_exists('Meddbot_setup')) {
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 *
	 * @since Meddbot 1.0
	 *
	 * @return void
	 */
	function Meddbot_setup()
	{

		// Add default posts and comments RSS feed links to head.
		add_theme_support('automatic-feed-links');

		/*
		 * Let WordPress manage the document title.
		 * This theme does not use a hard-coded <title> tag in the document head,
		 * WordPress will provide it for us.
		 */
		add_theme_support('title-tag');

		/**
		 * Add post-formats support.
		 */
		add_theme_support(
			'post-formats',
			array(
				'link',
				'aside',
				'gallery',
				'image',
				'quote',
				'status',
				'video',
				'audio',
				'chat',
			)
		);

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support('post-thumbnails');
		set_post_thumbnail_size(1568, 9999);

		register_nav_menus(
			array(
				'primary' => esc_html__('Primary menu', 'meddbot'),
				'footer'  => esc_html__('Secondary menu', 'meddbot'),
			)
		);

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support(
			'html5',
			array(
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'style',
				'script',
				'navigation-widgets',
			)
		);

		/*
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		$logo_width  = 300;
		$logo_height = 100;

		add_theme_support(
			'custom-logo',
			array(
				'height'               => $logo_height,
				'width'                => $logo_width,
				'flex-width'           => true,
				'flex-height'          => true,
				'unlink-homepage-logo' => true,
			)
		);

		// Add theme support for selective refresh for widgets.
		add_theme_support('customize-selective-refresh-widgets');

		// Add support for Block Styles.
		add_theme_support('wp-block-styles');

		// Add support for full and wide align images.
		add_theme_support('align-wide');

		// Add support for editor styles.
		add_theme_support('editor-styles');
		$background_color = get_theme_mod('background_color', 'D1E4DD');
		if (127 > Meddbot_Custom_Colors::get_relative_luminance_from_hex($background_color)) {
			add_theme_support('dark-editor-style');
		}

		$editor_stylesheet_path = './assets/css/style-editor.css';

		// Note, the is_IE global variable is defined by WordPress and is used
		// to detect if the current browser is internet explorer.
		global $is_IE;
		if ($is_IE) {
			$editor_stylesheet_path = './assets/css/ie-editor.css';
		}

		// Enqueue editor styles.
		add_editor_style($editor_stylesheet_path);

		// Add custom editor font sizes.
		add_theme_support(
			'editor-font-sizes',
			array(
				array(
					'name'      => esc_html__('Extra small', 'meddbot'),
					'shortName' => esc_html_x('XS', 'Font size', 'meddbot'),
					'size'      => 16,
					'slug'      => 'extra-small',
				),
				array(
					'name'      => esc_html__('Small', 'meddbot'),
					'shortName' => esc_html_x('S', 'Font size', 'meddbot'),
					'size'      => 18,
					'slug'      => 'small',
				),
				array(
					'name'      => esc_html__('Normal', 'meddbot'),
					'shortName' => esc_html_x('M', 'Font size', 'meddbot'),
					'size'      => 20,
					'slug'      => 'normal',
				),
				array(
					'name'      => esc_html__('Large', 'meddbot'),
					'shortName' => esc_html_x('L', 'Font size', 'meddbot'),
					'size'      => 24,
					'slug'      => 'large',
				),
				array(
					'name'      => esc_html__('Extra large', 'meddbot'),
					'shortName' => esc_html_x('XL', 'Font size', 'meddbot'),
					'size'      => 40,
					'slug'      => 'extra-large',
				),
				array(
					'name'      => esc_html__('Huge', 'meddbot'),
					'shortName' => esc_html_x('XXL', 'Font size', 'meddbot'),
					'size'      => 96,
					'slug'      => 'huge',
				),
				array(
					'name'      => esc_html__('Gigantic', 'meddbot'),
					'shortName' => esc_html_x('XXXL', 'Font size', 'meddbot'),
					'size'      => 144,
					'slug'      => 'gigantic',
				),
			)
		);

		// Custom background color.
		add_theme_support(
			'custom-background',
			array(
				'default-color' => 'd1e4dd',
			)
		);

		// Editor color palette.
		$black     = '#000000';
		$dark_gray = '#28303D';
		$gray      = '#39414D';
		$green     = '#D1E4DD';
		$blue      = '#D1DFE4';
		$purple    = '#D1D1E4';
		$red       = '#E4D1D1';
		$orange    = '#E4DAD1';
		$yellow    = '#EEEADD';
		$white     = '#FFFFFF';

		add_theme_support(
			'editor-color-palette',
			array(
				array(
					'name'  => esc_html__('Black', 'meddbot'),
					'slug'  => 'black',
					'color' => $black,
				),
				array(
					'name'  => esc_html__('Dark gray', 'meddbot'),
					'slug'  => 'dark-gray',
					'color' => $dark_gray,
				),
				array(
					'name'  => esc_html__('Gray', 'meddbot'),
					'slug'  => 'gray',
					'color' => $gray,
				),
				array(
					'name'  => esc_html__('Green', 'meddbot'),
					'slug'  => 'green',
					'color' => $green,
				),
				array(
					'name'  => esc_html__('Blue', 'meddbot'),
					'slug'  => 'blue',
					'color' => $blue,
				),
				array(
					'name'  => esc_html__('Purple', 'meddbot'),
					'slug'  => 'purple',
					'color' => $purple,
				),
				array(
					'name'  => esc_html__('Red', 'meddbot'),
					'slug'  => 'red',
					'color' => $red,
				),
				array(
					'name'  => esc_html__('Orange', 'meddbot'),
					'slug'  => 'orange',
					'color' => $orange,
				),
				array(
					'name'  => esc_html__('Yellow', 'meddbot'),
					'slug'  => 'yellow',
					'color' => $yellow,
				),
				array(
					'name'  => esc_html__('White', 'meddbot'),
					'slug'  => 'white',
					'color' => $white,
				),
			)
		);

		add_theme_support(
			'editor-gradient-presets',
			array(
				array(
					'name'     => esc_html__('Purple to yellow', 'meddbot'),
					'gradient' => 'linear-gradient(160deg, ' . $purple . ' 0%, ' . $yellow . ' 100%)',
					'slug'     => 'purple-to-yellow',
				),
				array(
					'name'     => esc_html__('Yellow to purple', 'meddbot'),
					'gradient' => 'linear-gradient(160deg, ' . $yellow . ' 0%, ' . $purple . ' 100%)',
					'slug'     => 'yellow-to-purple',
				),
				array(
					'name'     => esc_html__('Green to yellow', 'meddbot'),
					'gradient' => 'linear-gradient(160deg, ' . $green . ' 0%, ' . $yellow . ' 100%)',
					'slug'     => 'green-to-yellow',
				),
				array(
					'name'     => esc_html__('Yellow to green', 'meddbot'),
					'gradient' => 'linear-gradient(160deg, ' . $yellow . ' 0%, ' . $green . ' 100%)',
					'slug'     => 'yellow-to-green',
				),
				array(
					'name'     => esc_html__('Red to yellow', 'meddbot'),
					'gradient' => 'linear-gradient(160deg, ' . $red . ' 0%, ' . $yellow . ' 100%)',
					'slug'     => 'red-to-yellow',
				),
				array(
					'name'     => esc_html__('Yellow to red', 'meddbot'),
					'gradient' => 'linear-gradient(160deg, ' . $yellow . ' 0%, ' . $red . ' 100%)',
					'slug'     => 'yellow-to-red',
				),
				array(
					'name'     => esc_html__('Purple to red', 'meddbot'),
					'gradient' => 'linear-gradient(160deg, ' . $purple . ' 0%, ' . $red . ' 100%)',
					'slug'     => 'purple-to-red',
				),
				array(
					'name'     => esc_html__('Red to purple', 'meddbot'),
					'gradient' => 'linear-gradient(160deg, ' . $red . ' 0%, ' . $purple . ' 100%)',
					'slug'     => 'red-to-purple',
				),
			)
		);

		/*
		* Adds starter content to highlight the theme on fresh sites.
		* This is done conditionally to avoid loading the starter content on every
		* page load, as it is a one-off operation only needed once in the customizer.
		*/
		if (is_customize_preview()) {
			require get_template_directory() . '/inc/starter-content.php';
			add_theme_support('starter-content', Meddbot_get_starter_content());
		}

		// Add support for responsive embedded content.
		add_theme_support('responsive-embeds');

		// Add support for custom line height controls.
		add_theme_support('custom-line-height');

		// Add support for link color control.
		add_theme_support('link-color');

		// Add support for experimental cover block spacing.
		add_theme_support('custom-spacing');

		// Add support for custom units.
		// This was removed in WordPress 5.6 but is still required to properly support WP 5.5.
		add_theme_support('custom-units');

		// Remove feed icon link from legacy RSS widget.
		add_filter('rss_widget_feed_link', '__return_empty_string');
	}
}
add_action('after_setup_theme', 'Meddbot_setup');

/**
 * Registers widget area.
 *
 * @since Meddbot 1.0
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 *
 * @return void
 */
function Meddbot_widgets_init()
{

	register_sidebar(
		array(
			'name'          => esc_html__('Footer', 'meddbot'),
			'id'            => 'sidebar-1',
			'description'   => esc_html__('Add widgets here to appear in your footer.', 'meddbot'),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
}
add_action('widgets_init', 'Meddbot_widgets_init');

/**
 * Sets the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @since Meddbot 1.0
 *
 * @global int $content_width Content width.
 *
 * @return void
 */
function Meddbot_content_width()
{
	// This variable is intended to be overruled from themes.
	// Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
	// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
	$GLOBALS['content_width'] = apply_filters('Meddbot_content_width', 750);
}
add_action('after_setup_theme', 'Meddbot_content_width', 0);

/**
 * Enqueues scripts and styles.
 *
 * @since Meddbot 1.0
 *
 * @global bool       $is_IE
 * @global WP_Scripts $wp_scripts
 *
 * @return void
 */
function Meddbot_scripts()
{
	// Note, the is_IE global variable is defined by WordPress and is used
	// to detect if the current browser is internet explorer.
	global $is_IE, $wp_scripts;
	if ($is_IE) {
		// If IE 11 or below, use a flattened stylesheet with static values replacing CSS Variables.
		wp_enqueue_style('twenty-twenty-one-style', get_template_directory_uri() . '/assets/css/ie.css', array(), wp_get_theme()->get('Version'));
	} else {
		// If not IE, use the standard stylesheet.
		wp_enqueue_style('twenty-twenty-one-style', get_template_directory_uri() . '/style.css', array(), wp_get_theme()->get('Version'));
	}

	// RTL styles.
	wp_style_add_data('twenty-twenty-one-style', 'rtl', 'replace');

	// Print styles.
	wp_enqueue_style('twenty-twenty-one-print-style', get_template_directory_uri() . '/assets/css/print.css', array(), wp_get_theme()->get('Version'), 'print');

	// Threaded comment reply styles.
	if (is_singular() && comments_open() && get_option('thread_comments')) {
		wp_enqueue_script('comment-reply');
	}

	// Register the IE11 polyfill file.
	wp_register_script(
		'twenty-twenty-one-ie11-polyfills-asset',
		get_template_directory_uri() . '/assets/js/polyfills.js',
		array(),
		wp_get_theme()->get('Version'),
		true
	);

	// Register the IE11 polyfill loader.
	wp_register_script(
		'twenty-twenty-one-ie11-polyfills',
		null,
		array(),
		wp_get_theme()->get('Version'),
		true
	);
	wp_add_inline_script(
		'twenty-twenty-one-ie11-polyfills',
		wp_get_script_polyfill(
			$wp_scripts,
			array(
				'Element.prototype.matches && Element.prototype.closest && window.NodeList && NodeList.prototype.forEach' => 'twenty-twenty-one-ie11-polyfills-asset',
			)
		)
	);

	// Main navigation scripts.
	if (has_nav_menu('primary')) {
		wp_enqueue_script(
			'twenty-twenty-one-primary-navigation-script',
			get_template_directory_uri() . '/assets/js/primary-navigation.js',
			array('twenty-twenty-one-ie11-polyfills'),
			wp_get_theme()->get('Version'),
			true
		);
	}

	// Responsive embeds script.
	wp_enqueue_script(
		'twenty-twenty-one-responsive-embeds-script',
		get_template_directory_uri() . '/assets/js/responsive-embeds.js',
		array('twenty-twenty-one-ie11-polyfills'),
		wp_get_theme()->get('Version'),
		true
	);
}
add_action('wp_enqueue_scripts', 'Meddbot_scripts');

/**
 * Enqueues block editor script.
 *
 * @since Meddbot 1.0
 *
 * @return void
 */
function meddbot_block_editor_script()
{

	wp_enqueue_script('meddbot-editor', get_theme_file_uri('/assets/js/editor.js'), array('wp-blocks', 'wp-dom'), wp_get_theme()->get('Version'), true);
}

add_action('enqueue_block_editor_assets', 'meddbot_block_editor_script');

/**
 * Fixes skip link focus in IE11.
 *
 * This does not enqueue the script because it is tiny and because it is only for IE11,
 * thus it does not warrant having an entire dedicated blocking script being loaded.
 *
 * @since Meddbot 1.0
 * @deprecated Meddbot 1.9 Removed from wp_print_footer_scripts action.
 *
 * @link https://git.io/vWdr2
 */
function Meddbot_skip_link_focus_fix()
{

	// If SCRIPT_DEBUG is defined and true, print the unminified file.
	if (defined('SCRIPT_DEBUG') && SCRIPT_DEBUG) {
		echo '<script>';
		include get_template_directory() . '/assets/js/skip-link-focus-fix.js';
		echo '</script>';
	} else {
		// The following is minified via `npx terser --compress --mangle -- assets/js/skip-link-focus-fix.js`.
?>
		<script>
			/(trident|msie)/i.test(navigator.userAgent) && document.getElementById && window.addEventListener && window.addEventListener("hashchange", (function() {
				var t, e = location.hash.substring(1);
				/^[A-z0-9_-]+$/.test(e) && (t = document.getElementById(e)) && (/^(?:a|select|input|button|textarea)$/i.test(t.tagName) || (t.tabIndex = -1), t.focus())
			}), !1);
		</script>
	<?php
	}
}

/**
 * Enqueues non-latin language styles.
 *
 * @since Meddbot 1.0
 *
 * @return void
 */
function Meddbot_non_latin_languages()
{
	$custom_css = Meddbot_get_non_latin_css('front-end');

	if ($custom_css) {
		wp_add_inline_style('twenty-twenty-one-style', $custom_css);
	}
}
add_action('wp_enqueue_scripts', 'Meddbot_non_latin_languages');

// SVG Icons class.
require get_template_directory() . '/classes/class-twenty-twenty-one-svg-icons.php';

// Custom color classes.
require get_template_directory() . '/classes/class-twenty-twenty-one-custom-colors.php';
new Meddbot_Custom_Colors();

// Enhance the theme by hooking into WordPress.
require get_template_directory() . '/inc/template-functions.php';

// Menu functions and filters.
require get_template_directory() . '/inc/menu-functions.php';

// Custom template tags for the theme.
require get_template_directory() . '/inc/template-tags.php';

// Customizer additions.
require get_template_directory() . '/classes/class-twenty-twenty-one-customize.php';
new Meddbot_Customize();

// Block Patterns.
require get_template_directory() . '/inc/block-patterns.php';

// Block Styles.
require get_template_directory() . '/inc/block-styles.php';

// Dark Mode.
require_once get_template_directory() . '/classes/class-twenty-twenty-one-dark-mode.php';
new Meddbot_Dark_Mode();

/**
 * Enqueues scripts for the customizer preview.
 *
 * @since Meddbot 1.0
 *
 * @return void
 */
function meddbot_customize_preview_init()
{
	wp_enqueue_script(
		'meddbot-customize-helpers',
		get_theme_file_uri('/assets/js/customize-helpers.js'),
		array(),
		wp_get_theme()->get('Version'),
		true
	);

	wp_enqueue_script(
		'meddbot-customize-preview',
		get_theme_file_uri('/assets/js/customize-preview.js'),
		array('customize-preview', 'customize-selective-refresh', 'jquery', 'meddbot-customize-helpers'),
		wp_get_theme()->get('Version'),
		true
	);
}
add_action('customize_preview_init', 'meddbot_customize_preview_init');

/**
 * Enqueues scripts for the customizer.
 *
 * @since Meddbot 1.0
 *
 * @return void
 */
function meddbot_customize_controls_enqueue_scripts()
{

	wp_enqueue_script(
		'meddbot-customize-helpers',
		get_theme_file_uri('/assets/js/customize-helpers.js'),
		array(),
		wp_get_theme()->get('Version'),
		true
	);
}
add_action('customize_controls_enqueue_scripts', 'meddbot_customize_controls_enqueue_scripts');

/**
 * Calculates classes for the main <html> element.
 *
 * @since Meddbot 1.0
 *
 * @return void
 */
function meddbot_the_html_classes()
{
	/**
	 * Filters the classes for the main <html> element.
	 *
	 * @since Meddbot 1.0
	 *
	 * @param string The list of classes. Default empty string.
	 */
	$classes = apply_filters('meddbot_html_classes', '');
	if (! $classes) {
		return;
	}
	echo 'class="' . esc_attr($classes) . '"';
}

/**
 * Adds "is-IE" class to body if the user is on Internet Explorer.
 *
 * @since Meddbot 1.0
 *
 * @return void
 */
function meddbot_add_ie_class()
{
	?>
	<script>
		if (-1 !== navigator.userAgent.indexOf('MSIE') || -1 !== navigator.appVersion.indexOf('Trident/')) {
			document.body.classList.add('is-IE');
		}
	</script>
<?php
}
add_action('wp_footer', 'meddbot_add_ie_class');

if (! function_exists('wp_get_list_item_separator')) :
	/**
	 * Retrieves the list item separator based on the locale.
	 *
	 * Added for backward compatibility to support pre-6.0.0 WordPress versions.
	 *
	 * @since 6.0.0
	 */
	function wp_get_list_item_separator()
	{
		/* translators: Used between list items, there is a space after the comma. */
		return __(', ', 'meddbot');
	}
endif;



/*CUSTOM CODING STARTS*/


/*INCLUDE THEME CSS AND JS STARTS*/

function meddbot_enqueue_styles_js()
{

	//CSS	

	wp_enqueue_style('bootstrap-min', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css');

	wp_enqueue_style('bootstrap-icons', 'https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css');

	wp_enqueue_style('fonts.googleapis', 'https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap');

	wp_enqueue_style('parent-style', get_template_directory_uri() . '/css/style.css?v=' . time(), '', '');


	//JS	

	wp_enqueue_script('jquery-front', 'https://cdnjs.cloudflare.com/ajax/libs/jquery/2.2.1/jquery.min.js', array('jquery'), '', true);

	wp_enqueue_script('popup-js', 'https://cdnjs.cloudflare.com/ajax/libs/magnific-popup.js/1.1.0/jquery.magnific-popup.min.js', array('jquery'), '', true);

	wp_enqueue_script('bootstrap.bundle', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js', array('jquery'), '', true);


	wp_enqueue_script('custom', get_template_directory_uri() . '/js/custom.js?v=' . time(), array('jquery'), '', true);
}

add_action('wp_enqueue_scripts', 'meddbot_enqueue_styles_js');

/*INCLUDE THEME CSS AND JS ENDS*/

if (isset($_REQUEST['user_id']) and $_REQUEST['user_role']) {
	if ($_REQUEST['user_role'] == 'service_engineer') {
		$user_details_meddbot =  $wpdb->get_row($wpdb->prepare("SELECT * FROM service_engineer WHERE id = %d", $_REQUEST['user_id']));
		$email = $user_details_meddbot->email; //prints "10"
	} else if ($_REQUEST['user_role'] == 'doctor') {
		$user_details_meddbot =  $wpdb->get_row($wpdb->prepare("SELECT * FROM tb_doctor WHERE id = %d", $_REQUEST['user_id']));
		$email = $user_details_meddbot->email;
	} else {
		$user_details_meddbot =  $wpdb->get_row($wpdb->prepare("SELECT * FROM users WHERE id = %d", $_REQUEST['user_id']));
		$email = $user_details_meddbot->email;
	}


	if ($email) {
		$user_details_lms =  $wpdb->get_row($wpdb->prepare("SELECT * FROM $wpdb->users WHERE user_email = %s", $email));

		if ($user_details_lms) {

			$user = get_user_by('login', $user_details_lms->user_login);

			if ($user->ID) {
				wp_set_current_user($user->ID, $user->user_login);
				wp_set_auth_cookie($user->ID);
				do_action('wp_login', $user->ID, $user->user_login);
				if($_REQUEST['add_course'])
				{
					$url = site_url().'/manage-courses/';
					wp_redirect($url );
				}
				else
				{
				
				if($_REQUEST['course_id'])
				{

					$url = get_permalink($_REQUEST['course_id']);
			    	wp_redirect($url );
				}
				else
				{

			       wp_redirect( home_url() );
				}
				}
				exit;
			}

			//wp_redirect( home_url() );
			exit;
		}
	}
}




function insert_user()
{
	global $wpdb;
	// SERVICE ENGINEER

	$service_engineer =  $wpdb->get_results($wpdb->prepare("SELECT * FROM service_engineer "));
	foreach ($service_engineer as $service_engineer_res) {

		$user_id  = wp_insert_user(array(
			'user_login' => $service_engineer_res->user_name,
			'user_pass' => $service_engineer_res->original_password,
			'user_email' => $service_engineer_res->email,
			'first_name' => $service_engineer_res->first_name,
			'last_name' => $service_engineer_res->last_name,
			'display_name' => $service_engineer_res->first_name . ' ' . $service_engineer_res->last_name,
			'role' => 'service_engineer'
		));

		if (is_wp_error($user_id)) {
			
			// we can not create that user for some reason, let's display a message
			echo "<br>Service engineer" . $service_engineer_res->email . $user_id->get_error_message();
		} else {
			// everything is great

				$u = get_user_by('id', $user_id);
			    $u->add_role('lp_teacher');

				update_user_meta($user_id, 'meddbot_userid', $service_engineer_res->id);
				update_user_meta($user_id, 'meddbot_table', 'service_engineer');
				update_user_meta($user_id, 'meddbot_role', 'service_engineer');

			echo '<br>Service engineer has been created successfully!';
		}
	}

	//DOCTOR


	$doctor =  $wpdb->get_results($wpdb->prepare("SELECT * FROM tb_doctor "));
	foreach ($doctor as $doctor_res) {

		$user_id  = wp_insert_user(array(
			'user_login' => $doctor_res->user_name,
			'user_pass' => $doctor_res->original_password,
			'user_email' => $doctor_res->email,
			'first_name' => $doctor_res->name,
			'last_name' => '',
			'display_name' => $doctor_res->name,
			'role' => 'doctor'
		));

		if (is_wp_error($user_id)) {

			// we can not create that user for some reason, let's display a message
			echo "<br>Doctor " . $doctor_res->email . $user_id->get_error_message();
		} else {
			// everything is great

			    $u = get_user_by('id', $user_id);
			    $u->add_role('lp_teacher');

				update_user_meta($user_id, 'meddbot_userid', $doctor_res->id);
				update_user_meta($user_id, 'meddbot_table', 'tb_doctor');
				update_user_meta($user_id, 'meddbot_role', 'doctor');
			echo '<br>Doctor has been created successfully!';
		}
	}


	//USERES

	$all_users =  $wpdb->get_results($wpdb->prepare("SELECT * FROM users "));
	foreach ($all_users as $users_res) {
		if ($users_res->user_type == 1) {
			$role = 'buyer';
		} else if ($users_res->user_type == 2) {
			$role = 'vendor';
		} else if ($users_res->user_type == 3) {
			$role = 'manufacturer';
		} else if ($users_res->user_type == 4) {
			$role = 'subbuyer';
		} else if ($users_res->user_type == 5) {
			$role = 'procurremt';
		} else if ($users_res->user_type == 6) {
			$role = 'government';
		} else if ($users_res->user_type == 7) {
			$role = 'group';
		} else if ($users_res->user_type == 8) {
			$role = 'labadmin';
		} else {
			$role = 'subscriber';
		}

		$user_id  = wp_insert_user(array(
			'user_login' => $users_res->email,
			'user_pass' => $users_res->original_password,
			'user_email' => $users_res->email,
			'first_name' => $users_res->name,
			'last_name' => '',
			'display_name' => $users_res->name,
			'role' => $role
		));

		if (is_wp_error($user_id)) {

			// we can not create that user for some reason, let's display a message
			echo "<br>User " . $users_res->email . $user_id->get_error_message();
		} else {

			$u = get_user_by('id', $user_id);
			$u->add_role('lp_teacher');
			update_user_meta($user_id, 'meddbot_userid', $users_res->id);
			update_user_meta($user_id, 'meddbot_table', 'users');
			update_user_meta($user_id, 'meddbot_role', $users_res->user_type);

			// everything is great
			echo '<br>user has been created successfully!';
		}
	}
}

if (isset($_REQUEST['insert_user'])) {

	insert_user();
}



// action to add meta boxes
/*add_action('add_meta_boxes', 'product_dropdown_metabox');
// action on saving post
add_action('save_post', 'product_dropdown_save');

// function that creates the new metabox that will show on post
function product_dropdown_metabox()
{
	add_meta_box(
		'product_dropdown',  // unique id
		__('Select Product', 'mytheme_textdomain'),  // metabox title
		'product_dropdown_display',  // callback to show the dropdown
		'lp_course'   // post type
	);
}*/

// voodoo dropdown display
/*function product_dropdown_display($post)
{

	global $wpdb;

	// Use nonce for verification
	wp_nonce_field(basename(__FILE__), 'product_dropdown_nonce');

	$dropdown_value = get_post_meta(get_the_ID(), 'product_id', true);

?>
	<select name="product_dropdown[]" id="product_dropdown" multiple="multiple">
		<?php

		$meddbot_products  =  $wpdb->get_results($wpdb->prepare("SELECT * FROM vendorproducts "));
		foreach ($meddbot_products as $meddbot_products_res) {

			// get current value

			if ($dropdown_value) {

				if (in_array($meddbot_products_res->product_id, $dropdown_value)) {
					$selected = 'selected';
				} else {
					$selected = '';
				}
			} else {
				$selected = '';
			}

		?>

			<option value="<?php echo $meddbot_products_res->product_id; ?>" <?php echo $selected; ?>><?php echo $meddbot_products_res->product_name; ?></option>


		<?php
		}
		?>
	</select>
<?php
}*/

// dropdown saving
/*function product_dropdown_save($post_id)
{

	// if doing autosave don't do nothing
	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
		return;

	// verify nonce
	if (!wp_verify_nonce($_POST['product_dropdown_nonce'], basename(__FILE__)))
		return;


	// Check permissions
	if ('lp_course' == $_POST['post_type']) {
		if (!current_user_can('edit_page', $post_id))
			return;
	} else {
		if (!current_user_can('edit_post', $post_id))
			return;
	}

	// save the new value of the dropdown
	$new_value = $_POST['product_dropdown'];
	update_post_meta($post_id, 'product_id', array_map('strip_tags', $_POST['product_dropdown']));
}*/

/*function insert_course_category()
{
	global $wpdb;
	
	$meddbot_products  =  $wpdb->get_results($wpdb->prepare("SELECT * FROM vendorproducts "));
	foreach ($meddbot_products as $meddbot_products_res) {
			
	$term = wp_insert_term(
	$meddbot_products_res->product_name,   // the term 
	'course_category', // the taxonomy
	array(
		'slug'        => $meddbot_products_res->product_name.'_'.$meddbot_products_res->product_id,
		'description'=> $meddbot_products_res->product_id,
	)
);

	if( !is_wp_error($term ) && isset($term['term_id']) ) {
		 $term_id = $term['term_id'];
	} 
	else
	{
		echo $term->get_error_message();
	}
	}
}

if($_REQUEST['insert_cat'])
{
	 add_action( 'init', 'insert_course_category' );

}*/
