<?php
ob_start();
include "wp-load.php";
include "wp-config.php";
error_reporting(E_ERROR | E_PARSE);
ini_set('disply_errors', 0);


function get_all_courses()
{
	global $wpdb;

	$course_arr = array();

	$courses = $wpdb->get_results($wpdb->prepare("SELECT * from wp_posts WHERE wp_posts.post_type = 'lp_course' AND
        wp_posts.post_status = 'publish' order by wp_posts.ID desc"));

	if ($courses) {
		foreach ($courses as $course) {
			
			//print_r($course);
			
			 $terms = wp_get_post_terms( $course->ID, array( 'course_category') );  //print_r( $terms);
			 
			 $cat_arr = array();
            
			 foreach ( $terms as $term ) :
            
			   $cat_arr[] = $term->description;
			   
			endforeach;

			$course_image = wp_get_attachment_url(get_post_thumbnail_id($course->ID), 'full');
			$url = get_permalink($course->ID);
			if (count($cat_arr)>0) {

				$course_arr[] = array(
					'course_id' => $course->ID,
					'title' => $course->post_title,
					'url' => $url,
					'course_image' => $course_image,
					'course_level' => get_post_meta($course->ID, '_lp_level'),
					'lessons_count' => get_post_meta($course->ID, '_lp_offline_lesson_count'),
					'duration' => get_post_meta($course->ID, '_lp_duration'),
					'product_ids' => $cat_arr
				);
			}
		}
	}

	//print_r($course_arr);

	echo json_encode($course_arr);
}

if (isset($_REQUEST['courses'])) {

	get_all_courses();
}




// GET COURSES STARTS

function get_courses()
{

	global $wpdb;

	$course_arr = array();

	$course_cat = $_REQUEST['course_cat'];


	$courses = $wpdb->get_results($wpdb->prepare("SELECT * from wp_posts 
    LEFT JOIN 
        wp_term_relationships ON (wp_posts.ID = wp_term_relationships.object_id)
    WHERE 
        (wp_term_relationships.term_taxonomy_id IN ($course_cat)) AND
        wp_posts.post_type = 'lp_course' AND
        wp_posts.post_status = 'publish'
    GROUP BY wp_posts.ID"));

	if ($courses) {
		foreach ($courses as $course) {

			$course_image = wp_get_attachment_url(get_post_thumbnail_id($course->ID), 'full');
			$url = get_permalink($course->ID);

			$course_arr[] = array(
				'course_id' => $course->ID,
				'title' => $course->post_title,
				'url' => $url,
				'course_image' => $course_image,
				'course_level' => get_post_meta($course->ID, '_lp_level'),
				'lessons_count' => get_post_meta($course->ID, '_lp_offline_lesson_count'),
				'duration' => get_post_meta($course->ID, '_lp_duration')
			);
		}
	}

	//print_r($course_arr);

	echo json_encode($course_arr);
}

if (isset($_REQUEST['course_cat'])) {

	get_courses();
}


// GET CERTIFICATE

function get_certificate()
{
	global $wpdb;

	$certificates = array();

	$certificate = $wpdb->get_results($wpdb->prepare("SELECT * FROM wp_options WHERE option_name like '%user_cert%'"));

	if (isset($_REQUEST['uid']) and $_REQUEST['role']) {
		if ($_REQUEST['role'] == 'service_engineer') {
			$user_details_meddbot =  $wpdb->get_row($wpdb->prepare("SELECT * FROM service_engineer WHERE id = %d", $_REQUEST['uid']));
			$email = $user_details_meddbot->email; //prints "10"
		} else if ($_REQUEST['role'] == 'doctor') {
			$user_details_meddbot =  $wpdb->get_row($wpdb->prepare("SELECT * FROM tb_doctor WHERE id = %d", $_REQUEST['uid']));
			$email = $user_details_meddbot->email;
		} else {
			$user_details_meddbot =  $wpdb->get_row($wpdb->prepare("SELECT * FROM users WHERE id = %d", $_REQUEST['uid']));
			$email = $user_details_meddbot->email;
		}
	}


	if ($email) {

		$user_details_lms =  $wpdb->get_row($wpdb->prepare("SELECT * FROM $wpdb->users WHERE user_email = %s", $email));

		if ($user_details_lms) {

			$user_id = $user_details_lms->ID;


			$result = array();

			foreach ($certificate as $certificate_res) {

				//$user_id = 3;

				$certificates = unserialize($certificate_res->option_value);

				$cert_key = explode('user_cert_', $certificate_res->option_name);
				//echo $cert_key[0];
				/*	echo "<br>";
			echo '<pre>';
			print_r($certificates);
			echo '</pre>';*/

				if (in_array($user_id, $certificates)) {

					$user_info = get_userdata($user_id);

					$result[] = array(
						'certificate_url' => site_url() . '/certificates/' . $cert_key[1],
						'course_id' => $certificates['course_id'],
						'course_name' => get_the_title($certificates['course_id']),
						'user_email' => $user_info->user_email
					);
				} else {
					//echo "No certificate found";
				}
			}


			echo json_encode($result);
		}
	}
}

if (isset($_REQUEST['get_certificate'])) {

	get_certificate();
}


function register_user_from_meddbot()
{

	global $wpdb;

	if ($_REQUEST['role'] == 'service_engineer') {

		$service_engineer_res =  $wpdb->get_row($wpdb->prepare("SELECT * FROM service_engineer where id =" . $_REQUEST['uid'] . ""));

		$user_id  = wp_insert_user(array(
			'user_login' => $service_engineer_res->email,
			'user_pass' => $service_engineer_res->original_password,
			'user_email' => $service_engineer_res->email,
			'first_name' => $service_engineer_res->first_name,
			'last_name' => $service_engineer_res->last_name,
			'display_name' => $service_engineer_res->first_name . ' ' . $service_engineer_res->last_name,
			'role' => 'service_engineer'
		));

		if (is_wp_error($user_id)) {

			// we can not create that user for some reason, let's display a message
			echo "<br>Service engineer" . $service_engineer_res->email . $user_id->get_error_message();
		} else {

			$u = get_user_by('id', $user_id);
			$u->add_role('lp_teacher');

			update_user_meta($user_id, 'meddbot_userid', $service_engineer_res->id);
			update_user_meta($user_id, 'meddbot_table', 'service_engineer');
			update_user_meta($user_id, 'meddbot_role', 'service_engineer');
			update_user_meta($user_id, 'meddbot_username', $service_engineer_res->user_name);
			// everything is great
			echo '<br>Service engineer has been created successfully!';
		}
	}


	if ($_REQUEST['role'] == 'doctor') {

		//DOCTOR STARTS

		$doctor_res =  $wpdb->get_row($wpdb->prepare("SELECT * FROM tb_doctor where id=" . $_REQUEST['uid'] . " "));

		$user_id  = wp_insert_user(array(
			'user_login' => $doctor_res->email,
			'user_pass' => $doctor_res->original_password,
			'user_email' => $doctor_res->email,
			'first_name' => $doctor_res->name,
			'last_name' => '',
			'display_name' => $doctor_res->name,
			'role' => 'doctor'
		));

		if (is_wp_error($user_id)) {

			// we can not create that user for some reason, let's display a message
			echo "<br>Doctor " . $doctor_res->email . $user_id->get_error_message();
		} else {

			$u = get_user_by('id', $user_id);
			$u->add_role('lp_teacher');

			update_user_meta($user_id, 'meddbot_userid', $doctor_res->id);
			update_user_meta($user_id, 'meddbot_table', 'tb_doctor');
			update_user_meta($user_id, 'meddbot_role', 'doctor');
			update_user_meta($user_id, 'meddbot_username', $doctor_res->user_name);
			// everything is great
			echo '<br>Doctor has been created successfully!';
		}

		//DOCTOR ENDS

	}

	if ($_REQUEST['role'] == 'user') {

		//USER STARTS

		$users_res =  $wpdb->get_row($wpdb->prepare("SELECT * FROM users where id=" . $_REQUEST['uid'] . " "));

		if ($users_res->user_type == 1) {
			$role = 'buyer';
		} else if ($users_res->user_type == 2) {
			$role = 'vendor';
		} else if ($users_res->user_type == 3) {
			$role = 'manufacturer';
		} else if ($users_res->user_type == 4) {
			$role = 'subbuyer';
		} else if ($users_res->user_type == 5) {
			$role = 'procurremt';
		} else if ($users_res->user_type == 6) {
			$role = 'government';
		} else if ($users_res->user_type == 7) {
			$role = 'group';
		} else if ($users_res->user_type == 8) {
			$role = 'labadmin';
		} else {
			$role = 'subscriber';
		}

		$user_id  = wp_insert_user(array(
			'user_login' => $users_res->email,
			'user_pass' => $users_res->original_password,
			'user_email' => $users_res->email,
			'first_name' => $users_res->name,
			'last_name' => '',
			'display_name' => $users_res->name,
			'role' => $role
		));

		if (is_wp_error($user_id)) {

			// we can not create that user for some reason, let's display a message
			echo "<br>User " . $users_res->email . $user_id->get_error_message();
		} else {

			$u = get_user_by('id', $user_id);
			$u->add_role('lp_teacher');

			update_user_meta($user_id, 'meddbot_userid', $users_res->id);
			update_user_meta($user_id, 'meddbot_table', 'users');
			update_user_meta($user_id, 'meddbot_role', $users_res->user_type);
			update_user_meta($user_id, 'meddbot_username', $users_res->user_name);
			// everything is great
			echo '<br>user has been created successfully!';
		}

		//USER ENDS
	}
}

if ($_REQUEST['register'] == 'yes' && $_REQUEST['uid'] && $_REQUEST['role']) {
	register_user_from_meddbot();
}

//INSERT CATEGORY

function insert_course_category()
{
	global $wpdb;
	
	$product_id = $_REQUEST['pid'];	
	
	
	$meddbot_products_res  =  $wpdb->get_row($wpdb->prepare("SELECT * FROM vendorproducts where product_id='".$product_id."'"));
				
	$term = wp_insert_term(
	$meddbot_products_res->product_name,   // the term 
	'course_category', // the taxonomy
	array(
		'slug'        => $meddbot_products_res->product_name.'_'.$meddbot_products_res->product_id,
		'description'=> $meddbot_products_res->product_id,
	)
);

	if( !is_wp_error($term ) && isset($term['term_id']) ) {
		 $term_id = $term['term_id'];
		 //echo  $term_id;
	} 
	else
	{
		echo $term->get_error_message();
	}
}

if($_REQUEST['pid'])
{
	 insert_course_category();
	 //add_action( 'init', 'insert_course_category' );

}
