<?php

/**

 * Displays the site header.

 *

 * @package WordPress

 * @subpackage Meddbot

 * @since Meddbot 1.0

 */



$custom_logo_id = get_theme_mod('custom_logo');

$image = wp_get_attachment_image_src($custom_logo_id, 'full');

?>

<div class="container headCont">
  <div class="headerwraper">
    <div class="mobileHeader"> 
      
      <!-- LOGO-MOBILE START -->
      
      <div class="navbar-brand"><a class="navbar-brand logoWeb" href="<?php echo esc_url(home_url('/')); ?>"><img class="logo-img" src="<?php echo $image[0]; ?>" alt="MEDDBOT"></a></div>
      
      <!-- LOGO-MOBILE END -->
      
      <button data-trigger="navbar_main" class="d-lg-none btn btn-nav_toggle" type="button"> <i class="bi bi-list"></i></button>
    </div>
    <nav id="navbar_main" class="mobile-offcanvas navbar navbar-expand-md">
      <div class="colapHeader"> <a class="navbar-brand logoWeb" href="<?php echo esc_url(home_url('/')); ?>"><img class="logo-img" src="<?php echo $image[0]; ?>" alt="MEDDBOT"></a>
        <div class="offcanvas-header">
          <button class="btn-close"><i class="bi bi-x-lg"></i></button>
        </div>
      </div>
      <div class="collapse navbar-collapse alignRight">
        <ul class="navbar-nav mb-lg-0">
          <li class="nav-item"> <a class="nav-link" href="<?php echo esc_url(home_url('/')); ?>">Home</a> </li>
          <li class="nav-item"> <a class="nav-link" href="<?php echo esc_url(home_url('/')); ?>">Courses</a> </li>
          <li class="nav-item"> <a class="nav-link" target="_blank" href="https://www.meddbot.com/contact">Contact us</a> </li>
          
          <?php
if (is_user_logged_in()) {
global $current_user; 
wp_get_current_user();
?>
<li class="nav-item"> <a class="nav-link" href="<?php echo site_url();?>/lp-profile/">Profile</a> </li>
<li class="nav-item btn-Link"> <a class="nav-link btn" href="<?php echo wp_logout_url( home_url() ); ?>">Logout</a> </li>
<?php
}
else
{
?>
<li class="nav-item btn-Link"> <a class="nav-link btn" href="<?php echo site_url();?>/login/">Login</a> </li>
<li class="nav-item btn-Link"> <a class="nav-link btn" href="<?php echo site_url();?>/register/">Register</a> </li>
<?php
}
?>
        </ul>
      </div>
    </nav>
  </div>
</div>

