<?php
/**
 * The header.
 *
 * This is the template that displays all of the <head> section and everything up until main.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Meddbot
 * @since Meddbot 1.0
 */

?>
<!doctype html>
<html <?php language_attributes(); ?> <?php meddbot_the_html_classes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<?php wp_head(); ?>
</head>

<?php
if ( is_single() ) {
	
	$cour_cls = 'course-details';
}
else
{
	$cour_cls = '';
}
?>


<body class="<?php echo $cour_cls;?>">
<?php wp_body_open(); ?>
<!-- HEADER-START -->
<header id="mainHeader">
  <?php get_template_part( 'template-parts/header/site-header' ); ?>
  <span class="screen-darken"></span> </header>
 <?php
if ( is_single() ) {
	
	
}
else
{
  ?>
  
    <section class="innerBanner">
     <span class="r1"></span>
          <span class="r1 r2"></span>
          <span class="r1 r3"></span>
          <span class="r1 r4"></span>
          <span class="r1 r5"></span>
          <span class="r1 r6"></span>
          <span class="r1 r7"></span>
          <span class="r1 r8"></span>
          <span class="r1 r9"></span>
          <span class="r1 r10"></span>
      <div class="container">
        <div class="intro-content">
        <?php
			if ( is_front_page())
			{
			?>
            <h2>Courses</h2>
            <?php
			}
			else
			{
			?>
             <h2><?php echo get_the_title();?></h2>
             <?php
}
?>
            <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
            <?php
			if ( !is_front_page())
			{
			?>
                <li class="breadcrumb-item"><a href="<?php echo site_url();?>">Home</a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo get_the_title();?></li>
                <?php
			}
			?>
            </ol>
            </nav>
        </div>
      </div>
<!--      <div class="bnrImgs" style="background:url(https://www.meddbot.com/assetsnew/img/inner.png)"></div>-->
  </section>
<!-- HEADER-END --><?php
}
?>